#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	


	[TestFixture]
	public class DAL_Specimen : BaseTest 
	{
		
		private DataTable _dtPatientSpecimen;
		private DataTable _dtOrderedTest;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//**Get PatientSpecimen data
				this._dtPatientSpecimen = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientSpecimen WHERE SpecimenStatusCode = 'A' AND SpecimenUid IS NOT NULL AND SpecimenExpirationDate IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//***Get OrderedTest data
				this._dtOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedTest WHERE PatientSpecimenGuid IS NOT NULL AND OrderableTestID IN (1,3,4,5,6) AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetSpecimen_String_Pass()
		{
			string specimenUid = this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.SpecimenUid].ToString();

			DataTable dtTest = DAL.Specimen.GetSpecimen(specimenUid);

			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientGuid), TABLES.PatientSpecimen.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.VbecsSpecimenNumber), TABLES.PatientSpecimen.VbecsSpecimenNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenReceivedDate), TABLES.PatientSpecimen.SpecimenReceivedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenSource), TABLES.PatientSpecimen.SpecimenSource);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PhlebotomistId), TABLES.PatientSpecimen.PhlebotomistId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenStatusCode), TABLES.PatientSpecimen.SpecimenStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.DivisionCode), TABLES.PatientSpecimen.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator), TABLES.PatientSpecimen.UnacceptableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.MaintainableSpecimenIndicator), TABLES.PatientSpecimen.MaintainableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.MaximumSpecimenExpirationDays), TABLES.VamcDivision.MaximumSpecimenExpirationDays);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.EntryTechId), TABLES.PatientSpecimen.EntryTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.CannedCommentGuid), TABLES.PatientSpecimen.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenComments), TABLES.PatientSpecimen.SpecimenComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.RowVersion), TABLES.PatientSpecimen.RowVersion);
		}

		[Test]
		public void GetSpecimen_String_Fail()
		{
			DataTable dtTest = DAL.Specimen.GetSpecimen(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetSpecimen_Guid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];
			
			DataTable dtTest = DAL.Specimen.GetSpecimen(unitGuid);

			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientGuid), TABLES.PatientSpecimen.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.VbecsSpecimenNumber), TABLES.PatientSpecimen.VbecsSpecimenNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenReceivedDate), TABLES.PatientSpecimen.SpecimenReceivedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenSource), TABLES.PatientSpecimen.SpecimenSource);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PhlebotomistId), TABLES.PatientSpecimen.PhlebotomistId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenStatusCode), TABLES.PatientSpecimen.SpecimenStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.DivisionCode), TABLES.PatientSpecimen.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator), TABLES.PatientSpecimen.UnacceptableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.MaintainableSpecimenIndicator), TABLES.PatientSpecimen.MaintainableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.MaximumSpecimenExpirationDays), TABLES.VamcDivision.MaximumSpecimenExpirationDays);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.EntryTechId), TABLES.PatientSpecimen.EntryTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.CannedCommentGuid), TABLES.PatientSpecimen.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenComments), TABLES.PatientSpecimen.SpecimenComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.RowVersion), TABLES.PatientSpecimen.RowVersion);
		}

		[Test]
		public void GetSpecimen_Guid_Fail()
		{
			DataTable dtTest = DAL.Specimen.GetSpecimen(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void UpdateSpecimen_Pass()
		{
			this.RefreshData = true;

			System.Guid psGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];
			System.Guid patientGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientGuid];
			byte[] rowVersion = (byte[])this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.RowVersion];
			string specimenUid = DataCreator.GetNewSpecimenUid();

			DataTable dtUpdatePatientSpecimen = SprocHelper.GetUpdatePatientSpecimenSprocTable(psGuid, patientGuid, specimenUid, rowVersion);

			DataTable dtExceptions = null;
			System.Guid[] specimenGuids = new System.Guid[1];
			specimenGuids[0] = psGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.MaintainSpecimen);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.MaintainSpecimen, specimenGuids, Common.WorkloadTransactionType.Miscellanious, false);


			int retValue = DAL.Specimen.UpdateSpecimen(dtUpdatePatientSpecimen, dtExceptions, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(0, retValue, "ReturnValue");
		}

		[Test]
		public void UpdateSpecimen_WithException_Pass()
		{
			this.RefreshData = true;

			System.Guid psGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];
			System.Guid patientGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientGuid];
			byte[] rowVersion = (byte[])this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.RowVersion];
			string specimenUid = DataCreator.GetNewSpecimenUid();
			BOL.Specimen tmpS = new BOL.Specimen(psGuid);

			DataTable dtUpdatePatientSpecimen = SprocHelper.GetUpdatePatientSpecimenSprocTable(psGuid, patientGuid, specimenUid, rowVersion);

			BOL.ExceptionReport specimenExtendedException = new BOL.ExceptionReport(Common.ExceptionType.Specimen_expiration_date_extended, "Unit Test 3554", Environment.UserName);
			specimenExtendedException.GenerateExceptionSpecimen(null, tmpS);
			DataTable dtExceptions = specimenExtendedException.ExceptionData.Table.Clone();
			dtExceptions.Rows.Add(specimenExtendedException.ExceptionData.ItemArray);
			System.Guid[] specimenGuids = new System.Guid[1];
			specimenGuids[0] = psGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.MaintainSpecimen);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.MaintainSpecimen, specimenGuids, Common.WorkloadTransactionType.Miscellanious, false);
			
			dtWorkloadEvents = Common.Utility.AppendLastUpdateInformation(dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			int retValue = DAL.Specimen.UpdateSpecimen(dtUpdatePatientSpecimen, dtExceptions, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(0, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateSpecimen_Fail()
		{
			this.RefreshData = true;

			System.Guid psGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];
			System.Guid patientGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientGuid];
			byte[] rowVersion = new byte[8];
			string specimenUid = DataCreator.GetNewSpecimenUid();

			DataTable dtUpdatePatientSpecimen = SprocHelper.GetUpdatePatientSpecimenSprocTable(psGuid, patientGuid, specimenUid, rowVersion);
			DataTable dtExceptions = null;

			System.Guid[] specimenGuids = new System.Guid[1];
			specimenGuids[0] = psGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.MaintainSpecimen);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.MaintainSpecimen, specimenGuids, Common.WorkloadTransactionType.Miscellanious, false);

			DAL.Specimen.UpdateSpecimen(dtUpdatePatientSpecimen, dtExceptions, dtWorkloadEvents, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void InsertSpecimen_Pass()
		{
			this.RefreshData = true;

			System.Guid psGuid = System.Guid.NewGuid();
			System.Guid patientGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientGuid];
			string specimenUid = DataCreator.GetNewSpecimenUid();

			DataTable dtInsertPatientSpecimen = SprocHelper.GetInsertPatientSpecimenSprocTable(psGuid, patientGuid, specimenUid);

			DataTable dtExceptions = null;

			System.Guid[] specimenGuids = new System.Guid[1];
			specimenGuids[0] = psGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.MaintainSpecimen);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.MaintainSpecimen, specimenGuids, Common.WorkloadTransactionType.Miscellanious, false);


			int retValue = DAL.Specimen.InsertSpecimen(dtInsertPatientSpecimen, dtExceptions, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(0, retValue, "ReturnValue");
		}

		[Test]
		public void InsertSpecimen_WithException_Pass()
		{
			this.RefreshData = true;

			System.Guid psGuid = System.Guid.NewGuid();
			System.Guid patientGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientGuid];
			string specimenUid = DataCreator.GetNewSpecimenUid();
			BOL.Specimen tmpS = new BOL.Specimen(psGuid);
			tmpS.Patient = new BOL.Patient(patientGuid);

			DataTable dtInsertPatientSpecimen = SprocHelper.GetInsertPatientSpecimenSprocTable(psGuid, patientGuid, specimenUid);

			BOL.ExceptionReport specimenExtendedException = new BOL.ExceptionReport(Common.ExceptionType.Specimen_expiration_date_extended, "Unit Test 3554", Environment.UserName);
			specimenExtendedException.GenerateExceptionSpecimen(null, tmpS);
			DataTable dtExceptions = specimenExtendedException.ExceptionData.Table.Clone();
			dtExceptions.Rows.Add(specimenExtendedException.ExceptionData.ItemArray);

			System.Guid[] specimenGuids = new System.Guid[1];
			specimenGuids[0] = psGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.MaintainSpecimen);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.MaintainSpecimen, specimenGuids, Common.WorkloadTransactionType.Miscellanious, false);
			int retValue = DAL.Specimen.InsertSpecimen(dtInsertPatientSpecimen, dtExceptions, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(0, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.UniqueDatabaseConstraintViolatedException))]
		public void InsertSpecimen_Fail()
		{
			this.RefreshData = true;

			System.Guid psGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];
			System.Guid patientGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientGuid];
			string specimenUid = this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.SpecimenUid].ToString();

			System.Guid[] specimenGuids = new System.Guid[1];
			specimenGuids[0] = psGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.MaintainSpecimen);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.MaintainSpecimen, specimenGuids, Common.WorkloadTransactionType.Miscellanious, false);


			DataTable dtInsertPatientSpecimen = SprocHelper.GetInsertPatientSpecimenSprocTable(psGuid, patientGuid, specimenUid);
			DataTable dtExceptions = null;

			DAL.Specimen.InsertSpecimen(dtInsertPatientSpecimen, dtExceptions, dtWorkloadEvents, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void IsSpecimenAssociatedWithDiagnosticTest_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid];
			
			bool retValue = DAL.Specimen.IsSpecimenAssociatedWithDiagnosticTest(unitGuid);

			Assert.AreEqual(true , retValue, "ReturnValue-" + unitGuid.ToString());
		}

		[Test]
		public void IsSpecimenAssociatedWithDiagnosticTest_Fail()
		{
			System.Guid unitGuid = System.Guid.NewGuid();
			
			bool retValue = DAL.Specimen.IsSpecimenAssociatedWithDiagnosticTest(unitGuid);

			Assert.AreEqual(false, retValue, "ReturnValue");
		}

		[Test]
		public void GetSpecimenSearchDetails_Pass()
		{
			string specimenUid = this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.SpecimenUid].ToString();

			DataTable dtTest = DAL.Specimen.GetSpecimenSearchDetails(specimenUid, string.Empty, string.Empty);
			
			Assert.AreEqual(41, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.Phlebotomist), ARTIFICIAL.Phlebotomist);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator), TABLES.PatientSpecimen.UnacceptableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.MaintainableSpecimenIndicator), TABLES.PatientSpecimen.MaintainableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.CannedCommentGuid), TABLES.PatientSpecimen.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenComments), TABLES.PatientSpecimen.SpecimenComments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.RowVersion), TABLES.PatientSpecimen.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderStatus.OrderStatusText), TABLES.OrderStatus.OrderStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderStatus.OrderStatusCode), TABLES.OrderStatus.OrderStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientGuid), TABLES.PatientTreatment.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ConversionBloodTypeCode), ARTIFICIAL.ConversionBloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ConversionRhFactorCode), ARTIFICIAL.ConversionRhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientDob), TABLES.Patient.PatientDob);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSexCode), TABLES.Patient.PatientSexCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), TABLES.PatientOrder.OrderingProviderLastName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), TABLES.PatientOrder.OrderingProviderFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderMiddleInitial), TABLES.PatientOrder.OrderingProviderMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderComments), TABLES.PatientOrder.OrderComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderPlacedDatetime), TABLES.PatientOrder.OrderPlacedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.AboRhChangeIndicator), TABLES.Patient.AboRhChangeIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.VbecsOrderNumber), TABLES.OrderedTest.VbecsOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.CprsOrderNumber), TABLES.OrderedTest.CprsOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ComponentTestGuid), ARTIFICIAL.ComponentTestGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.OrderableTestId), TABLES.OrderedTest.OrderableTestId);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.ComponentTestName), ARTIFICIAL.ComponentTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.TaskStatusCode), TABLES.OrderedTest.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.PatientOrderGuid), TABLES.PatientOrder.PatientOrderGuid);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.ComponentTestComment), ARTIFICIAL.ComponentTestComment);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.PatientTreatmentGuid), TABLES.PatientOrder.PatientTreatmentGuid);
		}

		[Test]
		public void GetSpecimenSearchDetails_Fail()
		{
			DataTable dtTest = DAL.Specimen.GetSpecimenSearchDetails("YUMMY","IN MY","TUMMY");
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetSpecimenList_Pass()
		{
			string specimenUid = this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.SpecimenUid].ToString();
			DateTime expirationDate = Convert.ToDateTime(this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.SpecimenExpirationDate]);

			DataTable dtTest = DAL.Specimen.GetSpecimenList(specimenUid, string.Empty, string.Empty, expirationDate.Date);
			
			Assert.AreEqual(26, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.Phlebotomist), ARTIFICIAL.Phlebotomist);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator), TABLES.PatientSpecimen.UnacceptableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.MaintainableSpecimenIndicator), TABLES.PatientSpecimen.MaintainableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenReceivedDate), TABLES.PatientSpecimen.SpecimenReceivedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.RowVersion), TABLES.PatientSpecimen.RowVersion);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.CannedCommentGuid), TABLES.PatientSpecimen.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenComments), TABLES.PatientSpecimen.SpecimenComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientGuid), TABLES.PatientTreatment.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ConversionBloodTypeCode), ARTIFICIAL.ConversionBloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ConversionRhFactorCode), ARTIFICIAL.ConversionRhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientDob), TABLES.Patient.PatientDob);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSexCode), TABLES.Patient.PatientSexCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.AboRhChangeIndicator), TABLES.Patient.AboRhChangeIndicator);
		}

		[Test]
		public void GetSpecimenList_Fail()
		{
			DataTable dtTest = DAL.Specimen.GetSpecimenList("PLEASE", "INSERT", "GIRDER", DateTime.Now.AddYears(1).Date);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetTestResultsForSpecimen_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];

			DataTable dtTest = DAL.Specimen.GetTestResultsForSpecimen(unitGuid);
			
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.BloodTestTypeId), TABLES.SpecimenTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestResultId), TABLES.SpecimenTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestComments), TABLES.SpecimenTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.DivisionCode), TABLES.SpecimenTest.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.AboRhChangeIndicator), TABLES.SpecimenTest.AboRhChangeIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestDate), TABLES.SpecimenTest.TestDate);
		}

		[Test]
		public void GetTestResultsForSpecimen_Fail()
		{
			DataTable dtTest = DAL.Specimen.GetTestResultsForSpecimen(System.Guid.NewGuid());
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEmptyPatientSpecimenTable_Pass()
		{
			DataTable dtTest = DAL.Specimen.GetEmptyPatientSpecimenTable(true);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(18, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.DivisionCode), TABLES.PatientSpecimen.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientGuid), TABLES.PatientSpecimen.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PhlebotomistId), TABLES.PatientSpecimen.PhlebotomistId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PostTransfusionIndicator), TABLES.PatientSpecimen.PostTransfusionIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenReceivedDate), TABLES.PatientSpecimen.SpecimenReceivedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenSource), TABLES.PatientSpecimen.SpecimenSource);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenStatusCode), TABLES.PatientSpecimen.SpecimenStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator), TABLES.PatientSpecimen.UnacceptableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.VbecsSpecimenNumber), TABLES.PatientSpecimen.VbecsSpecimenNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.EntryTechId), TABLES.PatientSpecimen.EntryTechId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.CannedCommentGuid), TABLES.PatientSpecimen.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenComments), TABLES.PatientSpecimen.SpecimenComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.MaintainableSpecimenIndicator), TABLES.PatientSpecimen.MaintainableSpecimenIndicator);
		}

		[Test]
		public void GetEmptyPatientSpecimenTable_Fail()
		{
			DataTable dtTest = DAL.Specimen.GetEmptyPatientSpecimenTable(false);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(19, dtTest.Columns.Count, "Columsn.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.DivisionCode), TABLES.PatientSpecimen.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientGuid), TABLES.PatientSpecimen.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PhlebotomistId), TABLES.PatientSpecimen.PhlebotomistId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PostTransfusionIndicator), TABLES.PatientSpecimen.PostTransfusionIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenReceivedDate), TABLES.PatientSpecimen.SpecimenReceivedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenSource), TABLES.PatientSpecimen.SpecimenSource);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenStatusCode), TABLES.PatientSpecimen.SpecimenStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator), TABLES.PatientSpecimen.UnacceptableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.VbecsSpecimenNumber), TABLES.PatientSpecimen.VbecsSpecimenNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.EntryTechId), TABLES.PatientSpecimen.EntryTechId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.CannedCommentGuid), TABLES.PatientSpecimen.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenComments), TABLES.PatientSpecimen.SpecimenComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.MaintainableSpecimenIndicator), TABLES.PatientSpecimen.MaintainableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.RowVersion), TABLES.PatientSpecimen.RowVersion);
		}

		[Test]
		public void GetSpecimenHistory_Pass()
		{
			System.Guid specimenGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];

			DataTable dtTest = DAL.Specimen.GetSpecimenHistory(specimenGuid);
			
			Assert.AreEqual(15, dtTest.Columns.Count, "Columns.Count");			
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientGuid), TABLES.PatientSpecimen.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.VbecsSpecimenNumber), TABLES.PatientSpecimen.VbecsSpecimenNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenReceivedDate), TABLES.PatientSpecimen.SpecimenReceivedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenSource), TABLES.PatientSpecimen.SpecimenSource);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PhlebotomistId), TABLES.PatientSpecimen.PhlebotomistId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenStatusCode), TABLES.PatientSpecimen.SpecimenStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.DivisionCode), TABLES.PatientSpecimen.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator), TABLES.PatientSpecimen.UnacceptableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.MaintainableSpecimenIndicator), TABLES.PatientSpecimen.MaintainableSpecimenIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.CannedCommentGuid), TABLES.PatientSpecimen.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenComments), TABLES.PatientSpecimen.SpecimenComments);			
		}

		[Test]
		public void GetSpecimenHistory_Fail()
		{			
			DataTable dtTest = DAL.Specimen.GetSpecimenHistory(System.Guid.NewGuid());
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


	}
}
#endif

